CREATE TABLE Branding ( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),resource_type TEXT NOT NULL,resource_data TEXT NOT NULL,PRIMARY KEY (ProductID, resource_type) )
CREATE TABLE DependencyData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PayloadIDb TEXT ,type TEXT NOT NULL ,product_family TEXT, product_name TEXT, version TEXT, PRIMARY KEY (PayloadID,PayloadIDb,type,product_family,product_name,version))
CREATE TABLE EULA_Files( productID TEXT NOT NULL, langCode TEXT NOT NULL,eula TEXT NOT NULL,PRIMARY KEY (productID, langCode) )
CREATE TABLE PayloadData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),domain TEXT NOT NULL,key TEXT NOT NULL,value TEXT NOT NULL,PRIMARY KEY (PayloadID, domain, key) )
CREATE TABLE Payloads( PayloadID TEXT NOT NULL, payload_family TEXT NOT NULL,payload_name TEXT NOT NULL, payload_version TEXT NOT NULL,payload_type TEXT NOT NULL,PRIMARY KEY (PayloadID) )
CREATE TABLE SuitePayloads( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PRIMARY KEY (ProductID, PayloadID) )
CREATE TABLE Suites( ProductID TEXT NOT NULL, group_name TEXT NOT NULL, group_family TEXT NOT NULL, display_name TEXT NOT NULL, PRIMARY KEY (ProductID) )
CREATE TABLE EULA_Ref( productID TEXT NOT NULL, langCode TEXT NOT NULL, eula_hash TEXT NOT NULL, PRIMARY KEY (productID, langCode) )
CREATE TABLE EULA_Content(eula_hash TEXT NOT NULL, Content TEXT NOT NULL, PRIMARY KEY (eula_hash))
CREATE TABLE IF NOT EXISTS pcd_meta ( key TEXT NOT NULL, value TEXT NOT NULL, PRIMARY KEY (key) )
INSERT OR REPLACE INTO pcd_meta (key, value) VALUES ('schema_version', 2)
INSERT OR REPLACE INTO pcd_meta (key, value) VALUES ('schema_compatibility_version', 1)
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "", "required", "NonAdobePayload", "Microsoft Visual C++ 2005 Redistributable Package (x86)", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "", "required", "NonAdobePayload", "Microsoft Visual C++ 2008 Redistributable Package (x86)", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "", "required", "NonAdobePayload", "Microsoft Visual C++ 2010 Redistributable Package (x86)", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{C0E1B599-16D2-48EE-A094-8E3F8DA79819}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{44DAA82F-61F0-4336-9D23-1BE971808F48}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{D72017C0-E379-4B30-BC00-3510DDA85496}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{C846933E-47BF-4B18-ADE7-90DC18517509}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{CA3E99B8-AD3A-467B-AD7D-7ECC2E3A958A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{CA2E175E-9A2F-4B7A-AACA-36B5E1BA50A4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{DEA27A05-8E02-43C9-8512-7189F954B064}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{D1B4C8B4-19DA-419D-BF98-9B2937A41A3E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{CC0E183B-57B3-4473-BA50-16973DB416A5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{4BAF31BB-C255-404A-930D-10F8A03DEB23}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{98DA7F44-F21E-46BC-B565-0900A8307AF5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{AC574E5A-EA8B-49F5-B790-722B64183AD7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{0F60B065-B4E5-4554-97A2-DBC76F57025E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{51B1ED7F-58FA-43B4-882E-492925C893EB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{ABD92FEF-E535-495A-8343-72CD0F73AEA1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{163E4A7A-95A7-4DA1-AF40-6A731F48C1F0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{631EB569-EDE1-4907-B351-6074C8A43D44}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{2B0B1E4D-8AB5-4DB9-B8D2-46996006DE4A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{6BD0921D-791D-4CC8-81E7-DFA90D5155B2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{29F05C32-B2B3-41CD-B205-CC90885A4271}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{9C251CEB-1B53-43A2-BD7D-27F85B78348D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{25826534-E2EE-4195-8EAE-2BD4F38CBCEE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{89CBE313-C3AB-4B8C-B3E9-8CB3F2EBC4E3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{DC293BC6-A32A-47DE-AA2B-DC40D5B77F67}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{CA777365-1BA3-473A-8618-6A2B6EFF43FB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{DC980219-82B0-473A-85A7-D74D701FB061}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{C9D53241-D3E0-40DB-8705-2C2183BBAAF6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{0A29FB01-C384-43B4-A8D3-39101BE16184}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{12578DFE-9B05-4290-AC11-5F9FB1DD09D2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{63D5BFBF-6E2B-4D4E-BBB1-475743807A08}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{4FBA9CCC-42B4-4445-8AF0-3A4214359AD0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{F1A6B0DC-0768-429F-AD84-8ABB1178E66C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{DD60513B-3B5A-428E-9F53-71597DC2FB1F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{EEE6E181-6B81-4645-A949-894FC4062EE2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{44C163B8-B514-46FF-8EA9-82C4034E4C1A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{E4AF8EEF-9F07-4A00-A2D3-A87283B14604}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{3BD8803D-42E5-44EB-B255-FB86CC62E783}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{AAAA45EA-39B0-490D-BC6C-CCDB37053896}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{DDA357C8-89F4-4C1B-9458-31BD994C948F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{E66C53C2-32BF-4569-AB5E-CDE70A4E071B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{57F9AB0E-9098-48C1-9A26-0054A5069C75}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{61344D16-792B-4474-9182-413336B92F69}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{4DB25C1E-8FF4-4818-AD3C-1F908372B09D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{15C4B30B-10CC-4F97-8849-68663117F027}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{BE0564D4-8216-4CD7-9BE9-A0FD570B67E4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{D2C1E6E5-788F-44BC-A949-DC085665CB12}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{400B6765-EF15-495E-8249-BEE6CC561F9B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{A4365B6F-76EA-464F-8FCD-68C0B9E9A8F4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{CCBCBEB6-F57A-4F9F-9798-C8ECAEF91D4A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{2635B073-EE8B-4C42-B171-F2DB08A85104}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{F5462E64-8BAA-4090-8AED-A3923DCC56C1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{CBEF3671-8F57-4EBB-A11A-D327976A790B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{6F659531-A399-4030-B2F9-7371B5F577DB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{53E6D1B0-A9C4-4760-9707-782E3BBBD7FE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{4F91FE41-D964-4874-8B4E-42EC91CD708A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{F9A1CF0E-ECC0-416E-9D9F-BFE54338193D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{A5AACF3F-ECB2-40D7-B9E0-FA8D87209B06}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{7B24A384-CCDB-4D86-A619-A0F28754BC06}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{2196C77A-44B2-4E0F-8078-07160167908F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{D508EF07-EAAB-433F-A548-BD0FC949F956}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{458BD64E-657B-4DE0-B96B-2B452E51F31F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{AC889A40-A085-41A0-AF8C-45FF7ADB8231}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{03A1F058-FCF3-4351-8150-B44C2CCD1D94}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{CB8B7BD3-0028-452B-A009-378FB3E6CDD9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{E8C9F0A2-FFE8-48DE-8203-63EF091E3875}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{37EF28BD-AFBD-4A36-A80D-DF781A2A005F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{5D12B294-9AC7-4500-88EC-01289C237ACF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{B8DA35EA-DDE9-4BA9-92BF-D3B2BACFD1F8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{4CACA663-DDA2-455F-83ED-113897DC6B3B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{1C23D9B8-B0DE-4607-AF1D-A09F762D2CAD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{AAD2B6D3-4D77-4086-A7B6-7E432DBA3331}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{D73EE798-AF72-401F-A0A0-55D0E82C2740}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{6008442C-4E1A-4FC0-8047-FDFB689CB2E8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{378F2EFD-982F-4E0F-BC77-86A7726512BC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{A0EBEBA0-D6C9-4953-AEC7-C64D15DC7B03}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{44A3AFD6-5820-4BC7-A10A-567406A2830C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{C7447F6A-6678-447F-9C32-9370B5689657}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{3FFF8A78-4EA3-4EC4-872F-5CD6B1ACA13C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{9BB8549E-22B0-4864-95E4-6C687115C9E2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{DA8CFCEC-2A15-413B-BC8C-11C2B1DC6B4E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{04F57C27-9AB9-4F4E-B471-82796F3637B8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{78BAB81C-7CBE-45A9-8861-C05F5AD22448}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{1B265514-0931-480C-BA31-FB8A10F1CDF8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{86ACE33E-EEDA-4CB6-A97E-974D895DE9F6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{175F4F50-7011-431D-B54C-7B3492F815F3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{20064F26-463C-4FA6-A8D2-58D017F0F5B8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{68AE2CE0-0526-4681-B1F2-742857641809}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{8479FFFE-8B79-46C7-B5E5-907EDE5884CA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{4F17FF4E-0DB3-4A10-A726-6FFEE9678AB3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{47BE3ABC-1A33-4411-8826-46BCE202FA2D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{7CE1330B-9E61-4E24-B034-F65A58927FD4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{B4F22D56-6EF5-4C69-9532-2F480B2E7EC1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{35ACD222-5C98-4B87-AA64-EF388DBF24F8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{093830A4-097E-46C3-9DC3-53A25CEB66CC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{CBD5EDDC-BE75-42B9-9761-93D9D2F6CC97}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{15CB5D2C-07B1-4F2A-BD0C-D176C7D3E00C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{526EFAF4-BBB6-4FDC-9A05-6C937026CE2A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{74B9106C-E120-4319-BCE1-540BA830B29E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{862CDEE8-8166-450B-88DB-A6D663192891}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{8D71263F-96D8-4639-816B-117AF13414D0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{5CF4CF33-70C2-4C01-8ADA-8C74DB3AEADC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{BCA9C4B3-F3AA-4538-82B8-DE377BD995F0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{88A86139-D2C4-43F1-9B90-893C88AEE4E0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{4AB41DF6-65ED-43BB-8414-7FBE8FC53F60}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{B356EA60-BAEC-4994-B6BE-831723655AC1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{F4336D8B-A6AD-4D15-A58B-AF92DA023D22}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{45BA8503-A2F3-4741-B77B-4D56F4E8B442}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{42D9EF5A-AF0A-447A-8B1C-842CD4CFFAFA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{7EFCEB64-CA80-413E-BAAF-87524C0DE04C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{665F5744-9D41-4539-9175-13226827345B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{FB7B13F8-89A6-4D2D-987E-5CC8BF045517}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{517BAFA1-43FF-4D9C-9071-2F63E4E15B5D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{8238D279-EC61-42FC-8F87-579CEC739BF0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{57588955-F470-4A0F-ADD1-D08605A3EE9F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{6F7BE534-995A-4916-AC60-51F04E0F34AB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{A5A54532-8DAD-4685-BEED-4A032E4B2692}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{B3CF90DC-C28A-4478-953E-9243F191CB2E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{CAEABDC7-C711-468C-A509-EDD1D8B51BE8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{FF3970FD-14A4-47BB-8D67-A78F3A5788B3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{0517D863-7732-4292-AA45-19D95C6FD266}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{2DA5CE27-464E-47AE-A3C3-3CF836742B69}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{D4D59779-156D-4FF4-A33D-41D2C8B9F6F2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{F64C6C29-5F34-4231-B51E-6B70A45E34D9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{6408F727-892E-474E-8FF0-EC02070C327D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{79F602B2-89F5-4D15-99ED-3B55C0445CC7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{284C83AC-0F16-4605-8FA7-BE5B1C8B973A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{EB7F89A5-9836-4A93-9259-8B6B304B907E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{A0DF1E49-1974-47DD-AA27-F31F629F6766}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{21A57406-DF8D-4816-BC61-1F2F2F074C08}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{7E28667E-CFBE-4649-8899-8B29D7D18D23}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{9D4E9159-63E5-4581-897A-D38B65668104}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{92432F1B-E2F3-46C3-85EB-4478747D3737}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{6FEA15EA-623B-4E97-B251-E81DA848B7F1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{18C251BE-4BA0-4CD5-802C-925B27ACA980}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{810B8A60-D2B9-49E6-86EB-CC57E8DEDBD1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{79CD9885-30E7-40A4-BAF6-C0794B3C318C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{3F31496E-C673-43AA-A876-B252FCBBCD1C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{6DE7DBB2-8D5C-4E01-9C6B-4DCBB773F3BE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{77291F85-225E-4619-92F7-ADE21E7A7494}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{55BBE725-810A-4A22-878E-217D799B2B1E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{DED42925-D7A3-42FE-9789-4E448C13A304}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{A0281EF8-14CC-4787-8046-496B8C91D455}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{114900FD-551E-4220-9733-7505680EB457}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{D9E0F909-F54F-403E-A38D-DA9B711FAB47}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{84016824-2581-4F1C-AE3D-7685D9EE13E1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{FCF60894-9D6A-423C-9808-293CA093908C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{5BF369BB-C1C2-40C6-917B-307E4C0A98E3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{0C6B06C5-008D-4B0F-92D8-2F7F9ABD0428}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{854AEBBB-4B42-4A53-B087-74CD0CD2D56E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{02290AC2-8C5C-42A8-94A7-E24D59945F6F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{4758D4F4-7000-46C2-A99C-9E15803BCF59}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{6E6ADB7D-E242-4FD5-9208-17B84A674210}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{4AFE7298-3337-42EC-BAB1-D38AEC620D22}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{CFD99744-7E8B-4481-B198-3579804D836B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{02480DDC-0590-4496-9076-21AE860B43CD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{00483D6C-E74B-4252-87A8-78067917B7C9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{220531B7-0E86-40E0-85F9-6A991693843D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{F35AA145-4D31-4C61-B6EE-174D38303070}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{23F86A7E-A731-41E6-94AF-41B41FC2153A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{2A17F758-A06F-459B-94B1-8115E43ADA50}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{74FA8081-CAAB-46B0-BE98-EFFE410D1110}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{E55DCAB0-CCF5-498C-9761-F21C4C23034A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{CBF4CBDA-6BB4-468F-81BE-45BA0441C94F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{B3160C34-B375-4B75-BD52-733B638D9BEC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{C78878ED-AB69-4A33-8FCC-5A2F5EF8B150}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{7242C1E2-06B0-42CF-B9D5-DE43CF065EA4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{7C56E597-B253-41D5-AAE3-A4838E6E5B3E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{D5873B5A-0A52-43D5-82A5-2E73925E1631}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{31C1EA76-D749-402B-9DB4-6B256C7C2F9B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{CC5A0556-24A0-4894-9F4E-1FE19254C59C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{B7EC227D-6752-4AFE-9CEA-1D7ED0885767}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{7EC4F08E-E908-4AF1-BA50-54219663653A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{F042575A-935D-4D62-84E5-9725FF91B8BC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{50D75EF9-4FA6-4912-8FD3-4A6B711C1180}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{932B8E12-CDCE-4C41-9ECF-AE7238AB941A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{A0AAA34B-97D3-4F0E-BE6A-811ECDBB1779}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{710781C2-315F-439E-AA53-987074E52A48}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{E9677053-0D52-47E7-A68C-BC730C3588BA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{52F6154C-4E9F-4BA4-B2DD-482781CA0408}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{AB4285B3-E1B0-4357-88B6-7F3EC5E96F26}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{46516BCB-C314-4FA6-9B12-0185C60BF26D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{E96AF34F-E599-4CCD-9B20-98020429B96C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{1E949501-E5F6-4636-B407-F833F44A189B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{A4FAFC03-86A8-48AB-877B-3A765CDE037E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{3C42ECA4-05C9-43B7-AD36-6FC7CDBDAACC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{1EF53604-19ED-4011-A4C6-D982C4B786EC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{64FA94C3-DE1E-40FD-B688-6BDA4E709EEB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{144F4847-0E97-4148-81A9-AADEEA3DD06D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{DF5D3071-B827-4DC8-98F1-3726D0CF694F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{0CF05AD6-A929-43BE-8B40-9F733670C611}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{967DC2D9-C4B2-49D7-A4D4-94717E3418AF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{0FB48843-C250-47AB-BB4B-50D3EFDE3521}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{BB0A9BE8-494D-44EF-A7CB-293E8842687C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{9673A1C4-1D6F-4188-88E2-01F4CE9E9982}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{06A44619-6CED-4357-98B8-14E16790C557}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{496610AF-C634-4BB8-9A59-62FA5C8A9A4E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{196B859F-6751-4712-844E-E5BC8E95C549}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{A54E5349-52B6-48F4-8673-92B8BE7C3DB6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{BE003E4F-BB05-421D-B81D-23B0B4D7ADCF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{9296BC94-A6C2-4909-A9F1-061DF5894181}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{8BCC08BF-E34C-497C-8112-4D95B1EC1848}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{EAFFBBE9-FAB9-42AE-BA12-6E52CB09F7AD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{98018A33-B3C1-493D-AEA8-5E963692542F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{ACF7ECC1-D4BC-4AC8-AECA-66B6E2752470}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{0D7350C6-1E1B-4B63-8823-C4652805F406}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{99244E0F-117F-4F27-8296-B18ADE108D04}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{15050678-B60C-40B1-832B-D3C3425605FE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{3145D535-43D6-4766-A22D-81B2DB29024C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{02FA3741-2675-42BD-9B07-1F8DE3B31EDB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{CE979856-B068-4DCD-83CA-7DF83F8F13E9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{F648FCBE-53FA-4B6F-B10D-EC038EFD27C0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{494FF4DF-E378-4E00-8964-96EE59AC5B00}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{336DFD2C-447B-4F75-B69A-669C57720964}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{8FB46C48-245E-44B9-A041-A579EF5FE2C1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{4DF00E01-B35C-44DB-8F52-B8CF134D2106}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{BE6E8805-B838-40C9-AB49-9C4F05392C83}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{BF8658B7-7678-4795-A884-67C02DEF60D0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{35C57A14-5886-4AFB-9A1D-22B267661FED}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{DB135A69-3262-4046-A306-232CB77BF0AC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{BBD04211-BA58-4962-A024-36B9420E99FC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{F9237A44-8A85-473A-A321-E30BFF15880E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{D9C611AE-C8C3-4EA3-9E9A-42121BE5F69B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{4DD40800-D90C-444F-A5FD-60D352FDC0A2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{C222ECCF-5DA3-4378-AA4B-525CC4AB95CF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{85DCE770-846E-447B-86A8-9D743B35F1F8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{0BF7C0F0-4549-4B70-AD4B-33787A716DB2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{E55EAA86-0B81-4940-B8A3-685C09749CE0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{7ED0E406-D60F-4525-BA5E-2E81735E150E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{1DABFF99-42FA-4CBF-8C5B-E54CEE01F2CF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{65E8F5B9-B563-4104-89E8-DBE0C8BCC842}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{6301C843-8AA5-47BE-B4D1-291FADA50CFC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{532FAB4A-123C-49C1-832B-08A177A98F5E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{91FD10FB-FAC1-4270-9BF4-0B17EFCBB9C0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{45D5AF4E-C8A7-4B9E-A574-831C61A09B5D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{A4DB4F82-A916-407C-8D5C-C23DAD6241F9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{AEAAC771-D123-4170-B4AD-A765E659F1EA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{7B70202C-236D-45A8-A367-AD5C1E12E291}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{05F41A8F-294D-4B3F-8D1A-173874CEA049}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{B86A6A72-B7DD-4525-8409-55EBD82A2E1D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{880DB18B-833E-4EDF-86AB-E6C90ABE7B2D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{C653CE70-9B75-42B4-8558-4028622C52F0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{F1207873-8748-413F-95DD-8DFDC768D7D4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{83228408-7430-4DBB-813D-E8615FC2BEAA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{3E861FF0-44F6-4175-83A9-B8AC3E732EFB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{41A305C4-3403-4085-906C-92B8C9A98215}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{66623C08-BD19-4D4E-BA1A-D81B24AAFFEA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{6578D434-B2D5-4B99-8A5A-704831B10B6D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{702C416E-578C-4765-A771-8816CF2E5497}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{62F78C5A-F3E9-42D4-8A9A-BC3020A6A240}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{F307617C-A34C-46E0-866A-8D4E8A1FBE3D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{EA24BE26-832C-4CB6-84C2-2712480C0903}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{363D4D3D-273A-48C7-9170-FC6010CD2541}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{6DC8364E-F7FA-4F04-BBDA-E87BB2676830}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{71D62496-E576-4A0A-AB7D-75C455159D6D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{3E3DC5A8-2D14-44C1-AF2F-73D29DF9D788}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{90DE56DE-F7A9-432B-B65C-3B24093D0050}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{E773DCB9-B9D7-4948-A938-EFFBFA8D2F88}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{C3A459C1-E226-4D2B-8F85-6AC6E7893EF9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{F3287896-182D-48AA-879E-0061538AD7C4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{ABFC73D5-0041-4242-9AA8-CAF2CAF40D74}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{4055DDB6-37AB-450C-BA8B-E48922CBDD24}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{2F662809-8E05-47E2-8493-F0B19950D2BC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{CABFEA1E-48F4-47E1-90DE-F2CBFE157BBC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{46AD579C-EF9C-4D54-8F89-FF2E8CE5C3AE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{777457B5-F393-47B0-B663-EB7960557F8F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{FB58E9C9-F1F6-4E35-A17C-764118EFF2F5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{1CA1B767-DBCC-4A43-AFF0-C8257AA29087}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{0CC9263F-221B-49C8-9765-1E36C64AC48C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{F034D4CF-C7B1-46E1-A508-B5ADFDABE288}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{7C27B6AA-7042-4D35-A50A-76EC3577B84E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{35E33A32-A093-4EF8-83FC-358701CE7F79}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{F7B06041-9CE4-4D64-80FE-537620B30C80}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{26767273-45EB-43D1-ABB7-D3C1402B2FC3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{55558A43-A711-4011-8DAF-1FC5AF567F30}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{B4AC2854-32D3-440D-BE46-64C88ADA2360}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{A35EECB8-7B10-4BB2-9E62-8F6ACB4C4ACC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{DC7577C8-8395-4671-B4E0-EC554C489814}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{07660EC3-8B32-4CFE-A83D-0317FCC5DA99}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{1D209291-B5AB-41D8-8034-D4EE83A52993}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{AEDCBA72-C031-440C-B0A5-4F09915C715F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{B6A17875-4691-4287-9F34-368272F1B69B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{472F65AA-5C41-4AFD-8AC7-FBA4B2ED7B30}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{790F2361-9CE5-4E1D-8D29-27D08332E64D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{FE270676-7BCE-4566-83B7-5C69FDBDE871}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{48A505A0-A57D-4BD3-B75B-C5DC0493C87A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{4EA61964-4C5A-4B5E-A33B-82CF628CE08A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{0AEC3D08-736A-4295-8EDF-4E8FFEEE4F61}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{6167EB36-C5FB-48A4-A55E-FBA2975B2182}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{C041FF01-FA07-4138-B121-9119C13910AC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{FCBB6409-3119-46BC-AF35-7E454EAF86D0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{B3C58236-8B32-4B65-B593-07F95C6FDCE7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{FC504F98-98E8-4614-B866-5290C4350DC1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "{94B56D24-8736-4BE0-8F2F-87B68BBCE2FA}", "upgrade", "", "", "")
INSERT INTO PayloadData VALUES("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "0" , "ValidationInfo", '<ValidationInfo payloadID="{36682D68-3834-487E-BA49-DFA4AB0A2E32}"><File><InstallPath>[AdobeCommon]\CS6ServiceManager\adobe_caps.dll</InstallPath><SignatureType>DigitalSignature</SignatureType><SignatureInfo>Adobe Systems Incorporated{|}VeriSign Class 3 Code Signing 2010 CA{|}VeriSign Class 3 Public Primary Certification Authority - G5</SignatureInfo></File><File><InstallPath>[AdobeCommon]\CS6ServiceManager\CS6ServiceManager.exe</InstallPath><SignatureType>DigitalSignature</SignatureType><SignatureInfo>Adobe Systems Incorporated{|}VeriSign Class 3 Code Signing 2010 CA{|}VeriSign Class 3 Public Primary Certification Authority - G5</SignatureInfo></File><File><InstallPath>[AdobeCommon]\CS6ServiceManager\IMSLib.dll</InstallPath><SignatureType>DigitalSignature</SignatureType><SignatureInfo>Adobe Systems Incorporated{|}VeriSign Class 3 Code Signing 2010 CA{|}VeriSign Class 3 Public Primary Certification Authority - G5</SignatureInfo></File><File><InstallPath>[AdobeCommon]\CS6ServiceManager\VulcanControl.dll</InstallPath><SignatureType>DigitalSignature</SignatureType><SignatureInfo>Adobe Systems Incorporated{|}VeriSign Class 3 Code Signing 2010 CA{|}VeriSign Class 3 Public Primary Certification Authority - G5</SignatureInfo></File><File><InstallPath>[AdobeCommon]\CS6ServiceManager\lib\ServiceManager-Launcher.dll</InstallPath><SignatureType>DigitalSignature</SignatureType><SignatureInfo>Adobe Systems Incorporated{|}VeriSign Class 3 Code Signing 2010 CA{|}VeriSign Class 3 Public Primary Certification Authority - G5</SignatureInfo></File><File><InstallPath>[AdobeCommon]\CS6ServiceManager\lib\ServiceManager-Launcher_x64.dll</InstallPath><SignatureType>DigitalSignature</SignatureType><SignatureInfo>Adobe Systems Incorporated{|}VeriSign Class 3 Code Signing 2010 CA{|}VeriSign Class 3 Public Primary Certification Authority - G5</SignatureInfo></File></ValidationInfo>')
INSERT INTO PayloadData VALUES("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "0" , "ValidationSig", "WdEJi/PEl9FM4DagmpxFqyCLBhHC8Tx+Qelf2hIFlClDnCSr/yQcv8+7Rkvgrv+JWrC7DElgFSy4WSImsmNXc5bVn3z4NKQX4DU7WDy+b17QuJuQW1sQVLcOFV76CRXc1vMH6kY1funrAzPpKMBdb9PzXOX6ixZDrpkmhnrUMSttgJJj7A6His1bMNMpyUjmAcUZ2AcyKLJBcq4vJ8rPnlR5wLLQwAWYM6Ek43oMFOu429QGpGlEZewYVqL2zC3lemGwSyoDxOU5kge/ODQT5AMuhoYuKN1gc8kwm5667owo2+x0ElEMo4iPSAzeyJoO3mWt1516H5TkdwDipe5u0hIlc+Zu3d3Ll1RCYwBrnyAuH62bzTBM9BBJjB3ZECvYlIyW68RNYQuc4PsaGupKuL8oUh3xavxPe5AHYy2x6iJ1meAZAtlzP9j5qWJwihQZU3ABvvy1jElsuQN/N7ijOcILwRlwHsUfR+dvtqgjfzQ9ag5YMpux5AEq7+1XEvB2")
INSERT INTO Payloads VALUES	("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "Creative Suite", "Adobe CSXS Infrastructure CS6", "3", "normal")
INSERT INTO PayloadData VALUES("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "0" , "PayloadInfo", '<PayloadInfo version="6.0.29.0"><BuildInfo>
    <Property name="Created">2012-03-09 16:27:05.206000</Property>
    <Property name="TargetName">AdobeCSXSInfrastructure3-mul</Property>
    <Property name="ProcessorFamily">All</Property>
  </BuildInfo><InstallerProperties>
    <Property name="payloadType">SQLite</Property>
    <Property name="AdobeCode">{36682D68-3834-487E-BA49-DFA4AB0A2E32}</Property>
    <Property name="ProductName">Adobe CSXS Infrastructure CS6</Property>
    <Property name="ProductVersion">3</Property>
  </InstallerProperties><InstallDir>
    <Platform isFixed="1" name="Default" folderName="">[AdobeCommon]\CS6ServiceManager</Platform>
  </InstallDir><Languages languageIndependent="1"/><Satisfies>
    <ProductInfo>
		<Family>Creative Suite</Family>
		<!-- MAJOR-VERSION-UPDATE-MARKER (please do not remove this comment, required for automatic search) -->
		<ProductName>Adobe CSXS Infrastructure CS6</ProductName>
	<ProductVersion>3</ProductVersion>
    </ProductInfo>
  </Satisfies><Dependencies>
    <ProductInfo type="required">
      <Family>NonAdobePayload</Family>
      <ProductName>Microsoft Visual C++ 2005 Redistributable Package (x86)</ProductName>
    </ProductInfo>
    <ProductInfo type="required">
      <Family>NonAdobePayload</Family>
      <ProductName>Microsoft Visual C++ 2008 Redistributable Package (x86)</ProductName>
    </ProductInfo>
    <ProductInfo type="required">
      <Family>NonAdobePayload</Family>
      <ProductName>Microsoft Visual C++ 2010 Redistributable Package (x86)</ProductName>
    </ProductInfo>
  </Dependencies><Upgrades>
    <AdobeCode>{C0E1B599-16D2-48EE-A094-8E3F8DA79819}</AdobeCode>
    <AdobeCode>{44DAA82F-61F0-4336-9D23-1BE971808F48}</AdobeCode>
    <AdobeCode>{D72017C0-E379-4B30-BC00-3510DDA85496}</AdobeCode>
    <AdobeCode>{C846933E-47BF-4B18-ADE7-90DC18517509}</AdobeCode>
    <AdobeCode>{CA3E99B8-AD3A-467B-AD7D-7ECC2E3A958A}</AdobeCode>
    <AdobeCode>{CA2E175E-9A2F-4B7A-AACA-36B5E1BA50A4}</AdobeCode>
    <AdobeCode>{DEA27A05-8E02-43C9-8512-7189F954B064}</AdobeCode>
    <AdobeCode>{D1B4C8B4-19DA-419D-BF98-9B2937A41A3E}</AdobeCode>
    <AdobeCode>{CC0E183B-57B3-4473-BA50-16973DB416A5}</AdobeCode>
    <AdobeCode>{4BAF31BB-C255-404A-930D-10F8A03DEB23}</AdobeCode>
    <AdobeCode>{98DA7F44-F21E-46BC-B565-0900A8307AF5}</AdobeCode>
    <AdobeCode>{AC574E5A-EA8B-49F5-B790-722B64183AD7}</AdobeCode>
    <AdobeCode>{0F60B065-B4E5-4554-97A2-DBC76F57025E}</AdobeCode>
    <AdobeCode>{51B1ED7F-58FA-43B4-882E-492925C893EB}</AdobeCode>
    <AdobeCode>{ABD92FEF-E535-495A-8343-72CD0F73AEA1}</AdobeCode>
    <AdobeCode>{163E4A7A-95A7-4DA1-AF40-6A731F48C1F0}</AdobeCode>
    <AdobeCode>{631EB569-EDE1-4907-B351-6074C8A43D44}</AdobeCode>
    <AdobeCode>{2B0B1E4D-8AB5-4DB9-B8D2-46996006DE4A}</AdobeCode>
    <AdobeCode>{6BD0921D-791D-4CC8-81E7-DFA90D5155B2}</AdobeCode>
    <AdobeCode>{29F05C32-B2B3-41CD-B205-CC90885A4271}</AdobeCode>
    <AdobeCode>{9C251CEB-1B53-43A2-BD7D-27F85B78348D}</AdobeCode>
    <AdobeCode>{25826534-E2EE-4195-8EAE-2BD4F38CBCEE}</AdobeCode>
    <AdobeCode>{89CBE313-C3AB-4B8C-B3E9-8CB3F2EBC4E3}</AdobeCode>
    <AdobeCode>{DC293BC6-A32A-47DE-AA2B-DC40D5B77F67}</AdobeCode>
    <AdobeCode>{CA777365-1BA3-473A-8618-6A2B6EFF43FB}</AdobeCode>
    <AdobeCode>{DC980219-82B0-473A-85A7-D74D701FB061}</AdobeCode>
    <AdobeCode>{C9D53241-D3E0-40DB-8705-2C2183BBAAF6}</AdobeCode>
    <AdobeCode>{0A29FB01-C384-43B4-A8D3-39101BE16184}</AdobeCode>
    <AdobeCode>{12578DFE-9B05-4290-AC11-5F9FB1DD09D2}</AdobeCode>
    <AdobeCode>{63D5BFBF-6E2B-4D4E-BBB1-475743807A08}</AdobeCode>
    <AdobeCode>{4FBA9CCC-42B4-4445-8AF0-3A4214359AD0}</AdobeCode>
    <AdobeCode>{F1A6B0DC-0768-429F-AD84-8ABB1178E66C}</AdobeCode>
    <AdobeCode>{DD60513B-3B5A-428E-9F53-71597DC2FB1F}</AdobeCode>
    <AdobeCode>{EEE6E181-6B81-4645-A949-894FC4062EE2}</AdobeCode>
    <AdobeCode>{44C163B8-B514-46FF-8EA9-82C4034E4C1A}</AdobeCode>
    <AdobeCode>{E4AF8EEF-9F07-4A00-A2D3-A87283B14604}</AdobeCode>
    <AdobeCode>{3BD8803D-42E5-44EB-B255-FB86CC62E783}</AdobeCode>
    <AdobeCode>{AAAA45EA-39B0-490D-BC6C-CCDB37053896}</AdobeCode>
    <AdobeCode>{DDA357C8-89F4-4C1B-9458-31BD994C948F}</AdobeCode>
    <AdobeCode>{E66C53C2-32BF-4569-AB5E-CDE70A4E071B}</AdobeCode>
    <AdobeCode>{57F9AB0E-9098-48C1-9A26-0054A5069C75}</AdobeCode>
    <AdobeCode>{61344D16-792B-4474-9182-413336B92F69}</AdobeCode>
    <AdobeCode>{4DB25C1E-8FF4-4818-AD3C-1F908372B09D}</AdobeCode>
    <AdobeCode>{15C4B30B-10CC-4F97-8849-68663117F027}</AdobeCode>
    <AdobeCode>{BE0564D4-8216-4CD7-9BE9-A0FD570B67E4}</AdobeCode>
    <AdobeCode>{D2C1E6E5-788F-44BC-A949-DC085665CB12}</AdobeCode>
    <AdobeCode>{400B6765-EF15-495E-8249-BEE6CC561F9B}</AdobeCode>
    <AdobeCode>{A4365B6F-76EA-464F-8FCD-68C0B9E9A8F4}</AdobeCode>
    <AdobeCode>{CCBCBEB6-F57A-4F9F-9798-C8ECAEF91D4A}</AdobeCode>
    <AdobeCode>{2635B073-EE8B-4C42-B171-F2DB08A85104}</AdobeCode>
    <AdobeCode>{F5462E64-8BAA-4090-8AED-A3923DCC56C1}</AdobeCode>
    <AdobeCode>{CBEF3671-8F57-4EBB-A11A-D327976A790B}</AdobeCode>
    <AdobeCode>{6F659531-A399-4030-B2F9-7371B5F577DB}</AdobeCode>
    <AdobeCode>{53E6D1B0-A9C4-4760-9707-782E3BBBD7FE}</AdobeCode>
    <AdobeCode>{4F91FE41-D964-4874-8B4E-42EC91CD708A}</AdobeCode>
    <AdobeCode>{F9A1CF0E-ECC0-416E-9D9F-BFE54338193D}</AdobeCode>
    <AdobeCode>{A5AACF3F-ECB2-40D7-B9E0-FA8D87209B06}</AdobeCode>
    <AdobeCode>{7B24A384-CCDB-4D86-A619-A0F28754BC06}</AdobeCode>
    <AdobeCode>{2196C77A-44B2-4E0F-8078-07160167908F}</AdobeCode>
    <AdobeCode>{D508EF07-EAAB-433F-A548-BD0FC949F956}</AdobeCode>
    <AdobeCode>{458BD64E-657B-4DE0-B96B-2B452E51F31F}</AdobeCode>
    <AdobeCode>{AC889A40-A085-41A0-AF8C-45FF7ADB8231}</AdobeCode>
    <AdobeCode>{03A1F058-FCF3-4351-8150-B44C2CCD1D94}</AdobeCode>
    <AdobeCode>{CB8B7BD3-0028-452B-A009-378FB3E6CDD9}</AdobeCode>
    <AdobeCode>{E8C9F0A2-FFE8-48DE-8203-63EF091E3875}</AdobeCode>
    <AdobeCode>{37EF28BD-AFBD-4A36-A80D-DF781A2A005F}</AdobeCode>
    <AdobeCode>{5D12B294-9AC7-4500-88EC-01289C237ACF}</AdobeCode>
    <AdobeCode>{B8DA35EA-DDE9-4BA9-92BF-D3B2BACFD1F8}</AdobeCode>
    <AdobeCode>{4CACA663-DDA2-455F-83ED-113897DC6B3B}</AdobeCode>
    <AdobeCode>{1C23D9B8-B0DE-4607-AF1D-A09F762D2CAD}</AdobeCode>
    <AdobeCode>{AAD2B6D3-4D77-4086-A7B6-7E432DBA3331}</AdobeCode>
    <AdobeCode>{D73EE798-AF72-401F-A0A0-55D0E82C2740}</AdobeCode>
    <AdobeCode>{6008442C-4E1A-4FC0-8047-FDFB689CB2E8}</AdobeCode>
    <AdobeCode>{378F2EFD-982F-4E0F-BC77-86A7726512BC}</AdobeCode>
    <AdobeCode>{A0EBEBA0-D6C9-4953-AEC7-C64D15DC7B03}</AdobeCode>
    <AdobeCode>{44A3AFD6-5820-4BC7-A10A-567406A2830C}</AdobeCode>
    <AdobeCode>{C7447F6A-6678-447F-9C32-9370B5689657}</AdobeCode>
    <AdobeCode>{3FFF8A78-4EA3-4EC4-872F-5CD6B1ACA13C}</AdobeCode>
    <AdobeCode>{9BB8549E-22B0-4864-95E4-6C687115C9E2}</AdobeCode>
    <AdobeCode>{DA8CFCEC-2A15-413B-BC8C-11C2B1DC6B4E}</AdobeCode>
    <AdobeCode>{04F57C27-9AB9-4F4E-B471-82796F3637B8}</AdobeCode>
    <AdobeCode>{78BAB81C-7CBE-45A9-8861-C05F5AD22448}</AdobeCode>
    <AdobeCode>{1B265514-0931-480C-BA31-FB8A10F1CDF8}</AdobeCode>
    <AdobeCode>{86ACE33E-EEDA-4CB6-A97E-974D895DE9F6}</AdobeCode>
    <AdobeCode>{175F4F50-7011-431D-B54C-7B3492F815F3}</AdobeCode>
    <AdobeCode>{20064F26-463C-4FA6-A8D2-58D017F0F5B8}</AdobeCode>
    <AdobeCode>{68AE2CE0-0526-4681-B1F2-742857641809}</AdobeCode>
    <AdobeCode>{8479FFFE-8B79-46C7-B5E5-907EDE5884CA}</AdobeCode>
    <AdobeCode>{4F17FF4E-0DB3-4A10-A726-6FFEE9678AB3}</AdobeCode>
    <AdobeCode>{47BE3ABC-1A33-4411-8826-46BCE202FA2D}</AdobeCode>
    <AdobeCode>{7CE1330B-9E61-4E24-B034-F65A58927FD4}</AdobeCode>
    <AdobeCode>{B4F22D56-6EF5-4C69-9532-2F480B2E7EC1}</AdobeCode>
    <AdobeCode>{35ACD222-5C98-4B87-AA64-EF388DBF24F8}</AdobeCode>
    <AdobeCode>{093830A4-097E-46C3-9DC3-53A25CEB66CC}</AdobeCode>
    <AdobeCode>{CBD5EDDC-BE75-42B9-9761-93D9D2F6CC97}</AdobeCode>
    <AdobeCode>{15CB5D2C-07B1-4F2A-BD0C-D176C7D3E00C}</AdobeCode>
    <AdobeCode>{526EFAF4-BBB6-4FDC-9A05-6C937026CE2A}</AdobeCode>
    <AdobeCode>{74B9106C-E120-4319-BCE1-540BA830B29E}</AdobeCode>
    <AdobeCode>{862CDEE8-8166-450B-88DB-A6D663192891}</AdobeCode>
    <AdobeCode>{8D71263F-96D8-4639-816B-117AF13414D0}</AdobeCode>
    <AdobeCode>{5CF4CF33-70C2-4C01-8ADA-8C74DB3AEADC}</AdobeCode>
    <AdobeCode>{BCA9C4B3-F3AA-4538-82B8-DE377BD995F0}</AdobeCode>
    <AdobeCode>{88A86139-D2C4-43F1-9B90-893C88AEE4E0}</AdobeCode>
    <AdobeCode>{4AB41DF6-65ED-43BB-8414-7FBE8FC53F60}</AdobeCode>
    <AdobeCode>{B356EA60-BAEC-4994-B6BE-831723655AC1}</AdobeCode>
    <AdobeCode>{F4336D8B-A6AD-4D15-A58B-AF92DA023D22}</AdobeCode>
    <AdobeCode>{45BA8503-A2F3-4741-B77B-4D56F4E8B442}</AdobeCode>
    <AdobeCode>{42D9EF5A-AF0A-447A-8B1C-842CD4CFFAFA}</AdobeCode>
    <AdobeCode>{7EFCEB64-CA80-413E-BAAF-87524C0DE04C}</AdobeCode>
    <AdobeCode>{665F5744-9D41-4539-9175-13226827345B}</AdobeCode>
    <AdobeCode>{FB7B13F8-89A6-4D2D-987E-5CC8BF045517}</AdobeCode>
    <AdobeCode>{517BAFA1-43FF-4D9C-9071-2F63E4E15B5D}</AdobeCode>
    <AdobeCode>{8238D279-EC61-42FC-8F87-579CEC739BF0}</AdobeCode>
    <AdobeCode>{57588955-F470-4A0F-ADD1-D08605A3EE9F}</AdobeCode>
    <AdobeCode>{6F7BE534-995A-4916-AC60-51F04E0F34AB}</AdobeCode>
    <AdobeCode>{A5A54532-8DAD-4685-BEED-4A032E4B2692}</AdobeCode>
    <AdobeCode>{B3CF90DC-C28A-4478-953E-9243F191CB2E}</AdobeCode>
    <AdobeCode>{CAEABDC7-C711-468C-A509-EDD1D8B51BE8}</AdobeCode>
    <AdobeCode>{FF3970FD-14A4-47BB-8D67-A78F3A5788B3}</AdobeCode>
    <AdobeCode>{0517D863-7732-4292-AA45-19D95C6FD266}</AdobeCode>
    <AdobeCode>{2DA5CE27-464E-47AE-A3C3-3CF836742B69}</AdobeCode>
    <AdobeCode>{D4D59779-156D-4FF4-A33D-41D2C8B9F6F2}</AdobeCode>
    <AdobeCode>{F64C6C29-5F34-4231-B51E-6B70A45E34D9}</AdobeCode>
    <AdobeCode>{6408F727-892E-474E-8FF0-EC02070C327D}</AdobeCode>
    <AdobeCode>{79F602B2-89F5-4D15-99ED-3B55C0445CC7}</AdobeCode>
    <AdobeCode>{284C83AC-0F16-4605-8FA7-BE5B1C8B973A}</AdobeCode>
    <AdobeCode>{EB7F89A5-9836-4A93-9259-8B6B304B907E}</AdobeCode>
    <AdobeCode>{A0DF1E49-1974-47DD-AA27-F31F629F6766}</AdobeCode>
    <AdobeCode>{21A57406-DF8D-4816-BC61-1F2F2F074C08}</AdobeCode>
    <AdobeCode>{7E28667E-CFBE-4649-8899-8B29D7D18D23}</AdobeCode>
    <AdobeCode>{9D4E9159-63E5-4581-897A-D38B65668104}</AdobeCode>
    <AdobeCode>{92432F1B-E2F3-46C3-85EB-4478747D3737}</AdobeCode>
    <AdobeCode>{6FEA15EA-623B-4E97-B251-E81DA848B7F1}</AdobeCode>
    <AdobeCode>{18C251BE-4BA0-4CD5-802C-925B27ACA980}</AdobeCode>
    <AdobeCode>{810B8A60-D2B9-49E6-86EB-CC57E8DEDBD1}</AdobeCode>
    <AdobeCode>{79CD9885-30E7-40A4-BAF6-C0794B3C318C}</AdobeCode>
    <AdobeCode>{3F31496E-C673-43AA-A876-B252FCBBCD1C}</AdobeCode>
    <AdobeCode>{6DE7DBB2-8D5C-4E01-9C6B-4DCBB773F3BE}</AdobeCode>
    <AdobeCode>{77291F85-225E-4619-92F7-ADE21E7A7494}</AdobeCode>
    <AdobeCode>{55BBE725-810A-4A22-878E-217D799B2B1E}</AdobeCode>
    <AdobeCode>{DED42925-D7A3-42FE-9789-4E448C13A304}</AdobeCode>
    <AdobeCode>{A0281EF8-14CC-4787-8046-496B8C91D455}</AdobeCode>
    <AdobeCode>{114900FD-551E-4220-9733-7505680EB457}</AdobeCode>
    <AdobeCode>{D9E0F909-F54F-403E-A38D-DA9B711FAB47}</AdobeCode>
    <AdobeCode>{84016824-2581-4F1C-AE3D-7685D9EE13E1}</AdobeCode>
    <AdobeCode>{FCF60894-9D6A-423C-9808-293CA093908C}</AdobeCode>
    <AdobeCode>{5BF369BB-C1C2-40C6-917B-307E4C0A98E3}</AdobeCode>
    <AdobeCode>{0C6B06C5-008D-4B0F-92D8-2F7F9ABD0428}</AdobeCode>
    <AdobeCode>{854AEBBB-4B42-4A53-B087-74CD0CD2D56E}</AdobeCode>
    <AdobeCode>{02290AC2-8C5C-42A8-94A7-E24D59945F6F}</AdobeCode>
    <AdobeCode>{4758D4F4-7000-46C2-A99C-9E15803BCF59}</AdobeCode>
    <AdobeCode>{6E6ADB7D-E242-4FD5-9208-17B84A674210}</AdobeCode>
    <AdobeCode>{4AFE7298-3337-42EC-BAB1-D38AEC620D22}</AdobeCode>
    <AdobeCode>{CFD99744-7E8B-4481-B198-3579804D836B}</AdobeCode>
    <AdobeCode>{02480DDC-0590-4496-9076-21AE860B43CD}</AdobeCode>
    <AdobeCode>{00483D6C-E74B-4252-87A8-78067917B7C9}</AdobeCode>
    <AdobeCode>{220531B7-0E86-40E0-85F9-6A991693843D}</AdobeCode>
    <AdobeCode>{F35AA145-4D31-4C61-B6EE-174D38303070}</AdobeCode>
    <AdobeCode>{23F86A7E-A731-41E6-94AF-41B41FC2153A}</AdobeCode>
    <AdobeCode>{2A17F758-A06F-459B-94B1-8115E43ADA50}</AdobeCode>
    <AdobeCode>{74FA8081-CAAB-46B0-BE98-EFFE410D1110}</AdobeCode>
    <AdobeCode>{E55DCAB0-CCF5-498C-9761-F21C4C23034A}</AdobeCode>
    <AdobeCode>{CBF4CBDA-6BB4-468F-81BE-45BA0441C94F}</AdobeCode>
    <AdobeCode>{B3160C34-B375-4B75-BD52-733B638D9BEC}</AdobeCode>
    <AdobeCode>{C78878ED-AB69-4A33-8FCC-5A2F5EF8B150}</AdobeCode>
    <AdobeCode>{7242C1E2-06B0-42CF-B9D5-DE43CF065EA4}</AdobeCode>
    <AdobeCode>{7C56E597-B253-41D5-AAE3-A4838E6E5B3E}</AdobeCode>
    <AdobeCode>{D5873B5A-0A52-43D5-82A5-2E73925E1631}</AdobeCode>
    <AdobeCode>{31C1EA76-D749-402B-9DB4-6B256C7C2F9B}</AdobeCode>
    <AdobeCode>{CC5A0556-24A0-4894-9F4E-1FE19254C59C}</AdobeCode>
    <AdobeCode>{B7EC227D-6752-4AFE-9CEA-1D7ED0885767}</AdobeCode>
    <AdobeCode>{7EC4F08E-E908-4AF1-BA50-54219663653A}</AdobeCode>
    <AdobeCode>{F042575A-935D-4D62-84E5-9725FF91B8BC}</AdobeCode>
    <AdobeCode>{50D75EF9-4FA6-4912-8FD3-4A6B711C1180}</AdobeCode>
    <AdobeCode>{932B8E12-CDCE-4C41-9ECF-AE7238AB941A}</AdobeCode>
    <AdobeCode>{A0AAA34B-97D3-4F0E-BE6A-811ECDBB1779}</AdobeCode>
    <AdobeCode>{710781C2-315F-439E-AA53-987074E52A48}</AdobeCode>
    <AdobeCode>{E9677053-0D52-47E7-A68C-BC730C3588BA}</AdobeCode>
    <AdobeCode>{52F6154C-4E9F-4BA4-B2DD-482781CA0408}</AdobeCode>
    <AdobeCode>{AB4285B3-E1B0-4357-88B6-7F3EC5E96F26}</AdobeCode>
    <AdobeCode>{46516BCB-C314-4FA6-9B12-0185C60BF26D}</AdobeCode>
    <AdobeCode>{E96AF34F-E599-4CCD-9B20-98020429B96C}</AdobeCode>
    <AdobeCode>{1E949501-E5F6-4636-B407-F833F44A189B}</AdobeCode>
    <AdobeCode>{A4FAFC03-86A8-48AB-877B-3A765CDE037E}</AdobeCode>
    <AdobeCode>{3C42ECA4-05C9-43B7-AD36-6FC7CDBDAACC}</AdobeCode>
    <AdobeCode>{1EF53604-19ED-4011-A4C6-D982C4B786EC}</AdobeCode>
    <AdobeCode>{64FA94C3-DE1E-40FD-B688-6BDA4E709EEB}</AdobeCode>
    <AdobeCode>{144F4847-0E97-4148-81A9-AADEEA3DD06D}</AdobeCode>
    <AdobeCode>{DF5D3071-B827-4DC8-98F1-3726D0CF694F}</AdobeCode>
    <AdobeCode>{0CF05AD6-A929-43BE-8B40-9F733670C611}</AdobeCode>
    <AdobeCode>{967DC2D9-C4B2-49D7-A4D4-94717E3418AF}</AdobeCode>
    <AdobeCode>{0FB48843-C250-47AB-BB4B-50D3EFDE3521}</AdobeCode>
    <AdobeCode>{BB0A9BE8-494D-44EF-A7CB-293E8842687C}</AdobeCode>
    <AdobeCode>{9673A1C4-1D6F-4188-88E2-01F4CE9E9982}</AdobeCode>
    <AdobeCode>{06A44619-6CED-4357-98B8-14E16790C557}</AdobeCode>
    <AdobeCode>{496610AF-C634-4BB8-9A59-62FA5C8A9A4E}</AdobeCode>
    <AdobeCode>{196B859F-6751-4712-844E-E5BC8E95C549}</AdobeCode>
    <AdobeCode>{A54E5349-52B6-48F4-8673-92B8BE7C3DB6}</AdobeCode>
    <AdobeCode>{BE003E4F-BB05-421D-B81D-23B0B4D7ADCF}</AdobeCode>
    <AdobeCode>{9296BC94-A6C2-4909-A9F1-061DF5894181}</AdobeCode>
    <AdobeCode>{8BCC08BF-E34C-497C-8112-4D95B1EC1848}</AdobeCode>
    <AdobeCode>{EAFFBBE9-FAB9-42AE-BA12-6E52CB09F7AD}</AdobeCode>
    <AdobeCode>{98018A33-B3C1-493D-AEA8-5E963692542F}</AdobeCode>
    <AdobeCode>{ACF7ECC1-D4BC-4AC8-AECA-66B6E2752470}</AdobeCode>
    <AdobeCode>{0D7350C6-1E1B-4B63-8823-C4652805F406}</AdobeCode>
    <AdobeCode>{99244E0F-117F-4F27-8296-B18ADE108D04}</AdobeCode>
    <AdobeCode>{15050678-B60C-40B1-832B-D3C3425605FE}</AdobeCode>
    <AdobeCode>{3145D535-43D6-4766-A22D-81B2DB29024C}</AdobeCode>
    <AdobeCode>{02FA3741-2675-42BD-9B07-1F8DE3B31EDB}</AdobeCode>
    <AdobeCode>{CE979856-B068-4DCD-83CA-7DF83F8F13E9}</AdobeCode>
    <AdobeCode>{F648FCBE-53FA-4B6F-B10D-EC038EFD27C0}</AdobeCode>
    <AdobeCode>{494FF4DF-E378-4E00-8964-96EE59AC5B00}</AdobeCode>
    <AdobeCode>{336DFD2C-447B-4F75-B69A-669C57720964}</AdobeCode>
    <AdobeCode>{8FB46C48-245E-44B9-A041-A579EF5FE2C1}</AdobeCode>
    <AdobeCode>{4DF00E01-B35C-44DB-8F52-B8CF134D2106}</AdobeCode>
    <AdobeCode>{BE6E8805-B838-40C9-AB49-9C4F05392C83}</AdobeCode>
    <AdobeCode>{BF8658B7-7678-4795-A884-67C02DEF60D0}</AdobeCode>
    <AdobeCode>{35C57A14-5886-4AFB-9A1D-22B267661FED}</AdobeCode>
    <AdobeCode>{DB135A69-3262-4046-A306-232CB77BF0AC}</AdobeCode>
    <AdobeCode>{BBD04211-BA58-4962-A024-36B9420E99FC}</AdobeCode>
    <AdobeCode>{F9237A44-8A85-473A-A321-E30BFF15880E}</AdobeCode>
    <AdobeCode>{D9C611AE-C8C3-4EA3-9E9A-42121BE5F69B}</AdobeCode>
    <AdobeCode>{4DD40800-D90C-444F-A5FD-60D352FDC0A2}</AdobeCode>
    <AdobeCode>{C222ECCF-5DA3-4378-AA4B-525CC4AB95CF}</AdobeCode>
    <AdobeCode>{85DCE770-846E-447B-86A8-9D743B35F1F8}</AdobeCode>
    <AdobeCode>{0BF7C0F0-4549-4B70-AD4B-33787A716DB2}</AdobeCode>
    <AdobeCode>{E55EAA86-0B81-4940-B8A3-685C09749CE0}</AdobeCode>
    <AdobeCode>{7ED0E406-D60F-4525-BA5E-2E81735E150E}</AdobeCode>
    <AdobeCode>{1DABFF99-42FA-4CBF-8C5B-E54CEE01F2CF}</AdobeCode>
    <AdobeCode>{65E8F5B9-B563-4104-89E8-DBE0C8BCC842}</AdobeCode>
    <AdobeCode>{6301C843-8AA5-47BE-B4D1-291FADA50CFC}</AdobeCode>
    <AdobeCode>{532FAB4A-123C-49C1-832B-08A177A98F5E}</AdobeCode>
    <AdobeCode>{91FD10FB-FAC1-4270-9BF4-0B17EFCBB9C0}</AdobeCode>
    <AdobeCode>{45D5AF4E-C8A7-4B9E-A574-831C61A09B5D}</AdobeCode>
    <AdobeCode>{A4DB4F82-A916-407C-8D5C-C23DAD6241F9}</AdobeCode>
    <AdobeCode>{AEAAC771-D123-4170-B4AD-A765E659F1EA}</AdobeCode>
    <AdobeCode>{7B70202C-236D-45A8-A367-AD5C1E12E291}</AdobeCode>
    <AdobeCode>{05F41A8F-294D-4B3F-8D1A-173874CEA049}</AdobeCode>
    <AdobeCode>{B86A6A72-B7DD-4525-8409-55EBD82A2E1D}</AdobeCode>
    <AdobeCode>{880DB18B-833E-4EDF-86AB-E6C90ABE7B2D}</AdobeCode>
    <AdobeCode>{C653CE70-9B75-42B4-8558-4028622C52F0}</AdobeCode>
    <AdobeCode>{F1207873-8748-413F-95DD-8DFDC768D7D4}</AdobeCode>
    <AdobeCode>{83228408-7430-4DBB-813D-E8615FC2BEAA}</AdobeCode>
    <AdobeCode>{3E861FF0-44F6-4175-83A9-B8AC3E732EFB}</AdobeCode>
    <AdobeCode>{41A305C4-3403-4085-906C-92B8C9A98215}</AdobeCode>
    <AdobeCode>{66623C08-BD19-4D4E-BA1A-D81B24AAFFEA}</AdobeCode>
    <AdobeCode>{6578D434-B2D5-4B99-8A5A-704831B10B6D}</AdobeCode>
    <AdobeCode>{702C416E-578C-4765-A771-8816CF2E5497}</AdobeCode>
    <AdobeCode>{62F78C5A-F3E9-42D4-8A9A-BC3020A6A240}</AdobeCode>
    <AdobeCode>{F307617C-A34C-46E0-866A-8D4E8A1FBE3D}</AdobeCode>
    <AdobeCode>{EA24BE26-832C-4CB6-84C2-2712480C0903}</AdobeCode>
    <AdobeCode>{363D4D3D-273A-48C7-9170-FC6010CD2541}</AdobeCode>
    <AdobeCode>{6DC8364E-F7FA-4F04-BBDA-E87BB2676830}</AdobeCode>
    <AdobeCode>{71D62496-E576-4A0A-AB7D-75C455159D6D}</AdobeCode>
    <AdobeCode>{3E3DC5A8-2D14-44C1-AF2F-73D29DF9D788}</AdobeCode>
    <AdobeCode>{90DE56DE-F7A9-432B-B65C-3B24093D0050}</AdobeCode>
    <AdobeCode>{E773DCB9-B9D7-4948-A938-EFFBFA8D2F88}</AdobeCode>
    <AdobeCode>{C3A459C1-E226-4D2B-8F85-6AC6E7893EF9}</AdobeCode>
    <AdobeCode>{F3287896-182D-48AA-879E-0061538AD7C4}</AdobeCode>
    <AdobeCode>{ABFC73D5-0041-4242-9AA8-CAF2CAF40D74}</AdobeCode>
    <AdobeCode>{4055DDB6-37AB-450C-BA8B-E48922CBDD24}</AdobeCode>
    <AdobeCode>{2F662809-8E05-47E2-8493-F0B19950D2BC}</AdobeCode>
    <AdobeCode>{CABFEA1E-48F4-47E1-90DE-F2CBFE157BBC}</AdobeCode>
    <AdobeCode>{46AD579C-EF9C-4D54-8F89-FF2E8CE5C3AE}</AdobeCode>
    <AdobeCode>{777457B5-F393-47B0-B663-EB7960557F8F}</AdobeCode>
    <AdobeCode>{FB58E9C9-F1F6-4E35-A17C-764118EFF2F5}</AdobeCode>
    <AdobeCode>{1CA1B767-DBCC-4A43-AFF0-C8257AA29087}</AdobeCode>
    <AdobeCode>{0CC9263F-221B-49C8-9765-1E36C64AC48C}</AdobeCode>
    <AdobeCode>{F034D4CF-C7B1-46E1-A508-B5ADFDABE288}</AdobeCode>
    <AdobeCode>{7C27B6AA-7042-4D35-A50A-76EC3577B84E}</AdobeCode>
    <AdobeCode>{35E33A32-A093-4EF8-83FC-358701CE7F79}</AdobeCode>
    <AdobeCode>{F7B06041-9CE4-4D64-80FE-537620B30C80}</AdobeCode>
    <AdobeCode>{26767273-45EB-43D1-ABB7-D3C1402B2FC3}</AdobeCode>
    <AdobeCode>{55558A43-A711-4011-8DAF-1FC5AF567F30}</AdobeCode>
    <AdobeCode>{B4AC2854-32D3-440D-BE46-64C88ADA2360}</AdobeCode>
    <AdobeCode>{A35EECB8-7B10-4BB2-9E62-8F6ACB4C4ACC}</AdobeCode>
    <AdobeCode>{DC7577C8-8395-4671-B4E0-EC554C489814}</AdobeCode>
    <AdobeCode>{07660EC3-8B32-4CFE-A83D-0317FCC5DA99}</AdobeCode>
    <AdobeCode>{1D209291-B5AB-41D8-8034-D4EE83A52993}</AdobeCode>
    <AdobeCode>{AEDCBA72-C031-440C-B0A5-4F09915C715F}</AdobeCode>
    <AdobeCode>{B6A17875-4691-4287-9F34-368272F1B69B}</AdobeCode>
    <AdobeCode>{472F65AA-5C41-4AFD-8AC7-FBA4B2ED7B30}</AdobeCode>
    <AdobeCode>{790F2361-9CE5-4E1D-8D29-27D08332E64D}</AdobeCode>
    <AdobeCode>{FE270676-7BCE-4566-83B7-5C69FDBDE871}</AdobeCode>
    <AdobeCode>{48A505A0-A57D-4BD3-B75B-C5DC0493C87A}</AdobeCode>
    <AdobeCode>{4EA61964-4C5A-4B5E-A33B-82CF628CE08A}</AdobeCode>
    <AdobeCode>{0AEC3D08-736A-4295-8EDF-4E8FFEEE4F61}</AdobeCode>
    <AdobeCode>{6167EB36-C5FB-48A4-A55E-FBA2975B2182}</AdobeCode>
    <AdobeCode>{C041FF01-FA07-4138-B121-9119C13910AC}</AdobeCode>
    <AdobeCode>{FCBB6409-3119-46BC-AF35-7E454EAF86D0}</AdobeCode>
    <AdobeCode>{B3C58236-8B32-4B65-B593-07F95C6FDCE7}</AdobeCode>
    <AdobeCode>{FC504F98-98E8-4614-B866-5290C4350DC1}</AdobeCode>
    <AdobeCode>{94B56D24-8736-4BE0-8F2F-87B68BBCE2FA}</AdobeCode>
  </Upgrades><Channel enable="1" id="AdobeCSXSInfrastructureCS6-3">
    <DisplayName>Adobe CSXS Infrastructure CS6</DisplayName>
  </Channel><InstallDestinationMetadata relocatableSize="0" sysDriveSize="6466103"><Destination>
      <Root>[UserRoamingAppData]</Root>
      <TotalSize>0</TotalSize>
      <MaxPathComponent>/Adobe/CS6ServiceManager/configuration</MaxPathComponent>
    </Destination>
    <Destination>
      <Root>[AdobeCommon]</Root>
      <TotalSize>6466103</TotalSize>
      <MaxPathComponent>/CS6ServiceManager/StageManager/Release/META-INF/AIR\application.xml</MaxPathComponent>
    </Destination>
    <Assets>
      <Asset flag="0" name="Assets2_1" size="6466103"/>
    </Assets>
  </InstallDestinationMetadata><ConflictingProcesses>
	<Win32>
	<Process processType="Adobe" blocking="1">^[Aa][Ff][Tt][Ee][Rr][Ff][Xx].[Ee][Xx][Ee]</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Aa][Uu][Dd][Ii][Tt][Ii][Oo][Nn].[Ee][Xx][Ee]</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee][Cc][Aa][Pp][Tt][Ii][Vv][Aa][Tt][Ee].[Ee][Xx][Ee]</Process>
      <Process processType="Adobe" blocking="1">^[Cc][Oo][Nn][Tt][Rr][Ii][Bb][Uu][Tt][Ee].[Ee][Xx][Ee]</Process>
      <Process processType="Adobe" blocking="1">^[Ff][Ii][Rr][Ee][Ww][Oo][Rr][Kk][Ss].[Ee][Xx][Ee]</Process>
      <Process processType="Adobe" blocking="1">^[Ii][Ll][Ll][Uu][Ss][Tt][Rr][Aa][Tt][Oo][Rr].[Ee][Xx][Ee]</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Pp][Rr][Ee][Mm][Ii][Ee][Rr][Ee] [Pp][Rr][Oo].[Ee][Xx][Ee]</Process>
      <Process processType="Adobe" blocking="1">^[Dd][Ee][Vv][Ii][Cc][Ee][Cc][Ee][Nn][Tt][Rr][Aa][Ll].[Ee][Xx][Ee]</Process>
      <Process processType="Adobe" blocking="1">^[Dd][Rr][Ee][Aa][Mm][Ww][Ee][Aa][Vv][Ee][Rr].[Ee][Xx][Ee]</Process>
      <Process processType="Adobe" blocking="1">^[Ff][Ll][Aa][Ss][Hh].[Ee][Xx][Ee]</Process>
      <Process processType="Adobe" blocking="1">^[Ii][Nn][Cc][Oo][Pp][Yy].[Ee][Xx][Ee]</Process>
      <Process processType="Adobe" blocking="1">^[Ii][Nn][Dd][Ee][Ss][Ii][Gg][Nn].[Ee][Xx][Ee]</Process>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Ss][Hh][Oo][Pp].[Ee][Xx][Ee]</Process>
    </Win32>
<OSX>
      <Process processType="Adobe" blocking="1">^[Aa][Ff][Tt][Ee][Rr] [Ee][Ff][Ff][Ee][Cc][Tt][Ss]</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Aa][Uu][Dd][Ii][Tt][Ii][Oo][Nn]</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Cc][Aa][Pp][Tt][Ii][Vv][Aa][Tt][Ee]</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Cc][Oo][Nn][Tt][Rr][Ii][Bb][Uu][Tt][Ee] [Cc][Ss]6</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Ff][Ii][Rr][Ee][Ww][Oo][Rr][Kk][Ss] [Cc][Ss]6</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Ii][Ll][Ll][Uu][Ss][Tt][Rr][Aa][Tt][Oo][Rr]</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Pp][Rr][Ee][Mm][Ii][Ee][Rr][Ee] [Pp][Rr][Oo] [Cc][Ss]6</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Dd][Ee][Vv][Ii][Cc][Ee] [Cc][Ee][Nn][Tt][Rr][Aa][Ll] [Cc][Ss]6</Process>
      <Process processType="Adobe" blocking="1">^[Dd][Rr][Ee][Aa][Mm][Ww][Ee][Aa][Vv][Ee][Rr]</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Ff][Ll][Aa][Ss][Hh] [Cc][Ss]6</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Ii][Nn][Cc][Oo][Pp][Yy] [Cc][Ss]6</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Ii][Nn][Dd][Ee][Ss][Ii][Gg][Nn] [Cc][Ss]6</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Pp][Hh][Oo][Tt][Oo][Ss][Hh][Oo][Pp] [Cc][Ss]6</Process>
    </OSX>
  </ConflictingProcesses><AddRemoveInfo>
    <DisplayVersion>
      <Value lang="ar_AE">3</Value>
      <Value lang="be_BY">3</Value>
      <Value lang="bg_BG">3</Value>
      <Value lang="ca_ES">3</Value>
      <Value lang="cs_CZ">3</Value>
      <Value lang="da_DK">3</Value>
      <Value lang="de_DE">3</Value>
      <Value lang="el_GR">3</Value>
      <Value lang="en_GB">3</Value>
      <Value lang="en_MX">3</Value>
      <Value lang="en_US">3</Value>
      <Value lang="en_XC">3</Value>
      <Value lang="en_XM">3</Value>
      <Value lang="es_ES">3</Value>
      <Value lang="es_MX">3</Value>
      <Value lang="es_QM">3</Value>
      <Value lang="et_EE">3</Value>
      <Value lang="fi_FI">3</Value>
      <Value lang="fr_CA">3</Value>
      <Value lang="fr_FR">3</Value>
      <Value lang="fr_MX">3</Value>
      <Value lang="fr_XM">3</Value>
      <Value lang="he_IL">3</Value>
      <Value lang="hi_IN">3</Value>
      <Value lang="hr_HR">3</Value>
      <Value lang="hu_HU">3</Value>
      <Value lang="is_IS">3</Value>
      <Value lang="it_IT">3</Value>
      <Value lang="ja_JP">3</Value>
      <Value lang="ko_KR">3</Value>
      <Value lang="lt_LT">3</Value>
      <Value lang="lv_LV">3</Value>
      <Value lang="mk_MK">3</Value>
      <Value lang="nb_NO">3</Value>
      <Value lang="nl_NL">3</Value>
      <Value lang="nn_NO">3</Value>
      <Value lang="no_NO">3</Value>
      <Value lang="pl_PL">3</Value>
      <Value lang="pt_BR">3</Value>
      <Value lang="ro_RO">3</Value>
      <Value lang="ru_RU">3</Value>
      <Value lang="sh_YU">3</Value>
      <Value lang="sk_SK">3</Value>
      <Value lang="sl_SI">3</Value>
      <Value lang="sq_AL">3</Value>
      <Value lang="sv_SE">3</Value>
      <Value lang="th_TH">3</Value>
      <Value lang="tr_TR">3</Value>
      <Value lang="uk_UA">3</Value>
      <Value lang="vi_VN">3</Value>
      <Value lang="zh_CN">3</Value>
      <Value lang="zh_TW">3</Value>
      <Value lang="en_AE">3</Value>
      <Value lang="en_IL">3</Value>
      <Value lang="fr_MA">3</Value>
    </DisplayVersion>
    <DisplayName>
      <Value lang="ar_AE">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="be_BY">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="bg_BG">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="ca_ES">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="cs_CZ">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="da_DK">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="de_DE">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="el_GR">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="en_GB">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="en_MX">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="en_US">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="en_XC">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="en_XM">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="es_ES">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="es_MX">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="es_QM">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="et_EE">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="fi_FI">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="fr_CA">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="fr_FR">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="fr_MX">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="fr_XM">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="he_IL">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="hi_IN">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="hr_HR">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="hu_HU">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="is_IS">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="it_IT">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="ja_JP">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="ko_KR">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="lt_LT">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="lv_LV">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="mk_MK">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="nb_NO">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="nl_NL">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="nn_NO">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="no_NO">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="pl_PL">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="pt_BR">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="ro_RO">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="ru_RU">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="sh_YU">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="sk_SK">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="sl_SI">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="sq_AL">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="sv_SE">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="th_TH">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="tr_TR">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="uk_UA">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="vi_VN">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="zh_CN">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="zh_TW">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="en_AE">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="en_IL">Adobe CSXS Infrastructure CS6</Value>
      <Value lang="fr_MA">Adobe CSXS Infrastructure CS6</Value>
    </DisplayName>
  </AddRemoveInfo><UserPreferences>1</UserPreferences><SystemRequirements>
					 	<OS>
					 		<Macintosh>
					 			<Require lowerBound="1">
					 				<Version>10.5.0</Version>
					 				<Need64Bit>0</Need64Bit>
					 				<NeedServer>0</NeedServer>
					 			</Require>
					 		</Macintosh>
					 		<Windows>
					 			<XP>
					 				<Require>
					 					<MinServicePack servicePack64Bit="1">2</MinServicePack>
					 					<Need64Bit>0</Need64Bit>
					 				</Require>
					 			</XP>
					 			<Vista>
					 				<Require lowerBound="1"/>
					 			</Vista>
					 		</Windows>
					 	</OS>
					</SystemRequirements><CustomHook fileName="customaction.data"/></PayloadInfo>')
INSERT INTO PayloadData VALUES("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "0" , "WorkflowVersion", "CS6")
INSERT INTO PayloadData VALUES("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "0" , "DEVersion", "6.0")
INSERT INTO PayloadData VALUES("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "0", "ChannelID", "AdobeCSXSInfrastructureCS6-3")
INSERT INTO PayloadData VALUES("{36682D68-3834-487E-BA49-DFA4AB0A2E32}", "0", "ChannelInfo", '<Channel enable="1" id="AdobeCSXSInfrastructureCS6-3">
    <DisplayName>Adobe CSXS Infrastructure CS6</DisplayName>
  </Channel>')
